/** This demonstrates a native buffer access. It depends on a selected bit depth.
 */
#include "image.h"


int main(void)
{
Image Img;
unsigned x, y;

  Img.AttachRaster(CreateRaster2DRGB(255,255,8));
  if(Img.Raster==NULL) return -1;

  for(y=0; y<Img.Raster->Size2D; y++)
  {
    unsigned char * r1D = (unsigned char *)Img.Raster->GetRow(y);
    for(x=0; x<Img.Raster->Size1D; x++)
    {
      if(x>90 && y>90 && x<200 && y<200)
      {
        r1D[0] = 128;
        r1D[1] = 255;
        r1D[2] = x % 255;
      }
      else
        r1D[0] = r1D[1] = r1D[2] = 0;
      r1D += 3;
    }
  }

 return SavePicture("test3.bmp",Img);
}